<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRetail;

class GoogleLongrunningListOperationsResponse extends \Google\Collection
{
  protected $collection_key = 'unreachable';
  /**
   * The standard List next-page token.
   *
   * @var string
   */
  public $nextPageToken;
  protected $operationsType = GoogleLongrunningOperation::class;
  protected $operationsDataType = 'array';
  /**
   * Unordered list. Unreachable resources. Populated when the request sets
   * `ListOperationsRequest.return_partial_success` and reads across
   * collections. For example, when attempting to list all resources across all
   * supported locations.
   *
   * @var string[]
   */
  public $unreachable;

  /**
   * The standard List next-page token.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * A list of operations that matches the specified filter in the request.
   *
   * @param GoogleLongrunningOperation[] $operations
   */
  public function setOperations($operations)
  {
    $this->operations = $operations;
  }
  /**
   * @return GoogleLongrunningOperation[]
   */
  public function getOperations()
  {
    return $this->operations;
  }
  /**
   * Unordered list. Unreachable resources. Populated when the request sets
   * `ListOperationsRequest.return_partial_success` and reads across
   * collections. For example, when attempting to list all resources across all
   * supported locations.
   *
   * @param string[] $unreachable
   */
  public function setUnreachable($unreachable)
  {
    $this->unreachable = $unreachable;
  }
  /**
   * @return string[]
   */
  public function getUnreachable()
  {
    return $this->unreachable;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleLongrunningListOperationsResponse::class, 'Google_Service_CloudRetail_GoogleLongrunningListOperationsResponse');
