<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudIdentity;

class IsInvitableUserResponse extends \Google\Model
{
  /**
   * Returns true if the email address is invitable.
   *
   * @var bool
   */
  public $isInvitableUser;

  /**
   * Returns true if the email address is invitable.
   *
   * @param bool $isInvitableUser
   */
  public function setIsInvitableUser($isInvitableUser)
  {
    $this->isInvitableUser = $isInvitableUser;
  }
  /**
   * @return bool
   */
  public function getIsInvitableUser()
  {
    return $this->isInvitableUser;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(IsInvitableUserResponse::class, 'Google_Service_CloudIdentity_IsInvitableUserResponse');
