<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class DeobfuscationFile extends \Google\Model
{
  /**
   * Unspecified deobfuscation file type.
   */
  public const SYMBOL_TYPE_deobfuscationFileTypeUnspecified = 'deobfuscationFileTypeUnspecified';
  /**
   * Proguard deobfuscation file type.
   */
  public const SYMBOL_TYPE_proguard = 'proguard';
  /**
   * Native debugging symbols file type.
   */
  public const SYMBOL_TYPE_nativeCode = 'nativeCode';
  /**
   * The type of the deobfuscation file.
   *
   * @var string
   */
  public $symbolType;

  /**
   * The type of the deobfuscation file.
   *
   * Accepted values: deobfuscationFileTypeUnspecified, proguard, nativeCode
   *
   * @param self::SYMBOL_TYPE_* $symbolType
   */
  public function setSymbolType($symbolType)
  {
    $this->symbolType = $symbolType;
  }
  /**
   * @return self::SYMBOL_TYPE_*
   */
  public function getSymbolType()
  {
    return $this->symbolType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DeobfuscationFile::class, 'Google_Service_AndroidPublisher_DeobfuscationFile');
